/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.timing;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.video.test.CountingClock;

public class TimingTestBase {
    private static final int MEMORY_SIZE = 512;
    private Cpu6502 cpu = new Cpu6502();
    private CountingClock clock = new CountingClock();
    private MemoryBlock memory_block = new MemoryBlock(512);

    public TimingTestBase() {
        this.cpu.attach(this.memory_block, this.clock);
    }

    public void resizeMemory(int size) {
        this.memory_block = new MemoryBlock(size);
        this.cpu.attach(this.memory_block, this.clock);
    }

    public void setMemoryWord(int address, int word) throws EmulatorException {
        this.memory_block.write(address, word & 0xFF);
        this.memory_block.write(address + 1, word >> 8 & 0xFF);
    }

    public void setRegisters(int accu, int x, int y, int flags) {
        this.cpu.setAccu(new HwByte((long)accu));
        this.cpu.setX(new HwByte((long)x));
        this.cpu.setY(new HwByte((long)y));
        this.cpu.setFlags(new Flags6502((long)flags));
    }

    public void setCommand(int address, int command, int op1, int op2) throws EmulatorException {
        this.memory_block.write(address, command);
        this.memory_block.write(address + 1, op1);
        this.memory_block.write(address + 2, op2);
        this.cpu.setPC(address);
    }

    public void execute() throws EmulatorException {
        this.cpu.setSP(new HwByte(127L));
        this.cpu.next();
    }

    public int getElapsedCycles() {
        return this.clock.getCounterValue();
    }
}

